/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.liquid.ILiquidStack;
import net.dries007.tfc.api.recipes.BloomeryRecipe;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.compat.crafttweaker.CTHelper;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.terrafirmacraft.Bloomery")
@ZenRegister
public class CTBloomery {
    @ZenMethod
    public static void addRecipe(String metal, crafttweaker.api.item.IIngredient additive) {
        final Metal result = TFCRegistries.METALS.getValuesCollection().stream().filter(x -> x.getRegistryName().func_110623_a().equalsIgnoreCase(metal)).findFirst().orElse(null);
        if (result == null) {
            throw new IllegalArgumentException("Metal specified not found!");
        }
        if (BloomeryRecipe.get(result) != null) {
            throw new IllegalStateException("Recipe for that metal already exists!");
        }
        if (additive == null) {
            throw new IllegalArgumentException("Additive is not allowed to be empty");
        }
        if (additive instanceof ILiquidStack) {
            throw new IllegalArgumentException("There is a fluid where it's supposed to be an item!");
        }
        IIngredient ingredient = CTHelper.getInternalIngredient(additive);
        final BloomeryRecipe recipe = new BloomeryRecipe(result, ingredient);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                TFCRegistries.BLOOMERY.register((IForgeRegistryEntry)recipe);
            }

            public String describe() {
                return "Adding bloomery recipe for " + result.getRegistryName().func_110623_a();
            }
        });
    }

    @ZenMethod
    public static void removeRecipe(String metal) {
        Metal result = TFCRegistries.METALS.getValuesCollection().stream().filter(x -> x.getRegistryName().func_110623_a().equalsIgnoreCase(metal)).findFirst().orElse(null);
        if (result == null) {
            throw new IllegalArgumentException("Metal specified not found!");
        }
        final BloomeryRecipe recipe = BloomeryRecipe.get(result);
        if (recipe != null) {
            CraftTweakerAPI.apply((IAction)new IAction(){

                public void apply() {
                    IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)TFCRegistries.BLOOMERY;
                    modRegistry.remove(recipe.getRegistryName());
                }

                public String describe() {
                    return "Removing bloomery recipe " + recipe.getRegistryName().toString();
                }
            });
        }
    }
}

